package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Wstawia dane w sesji, kontekcie serwletu i dwch plikach cookies.
 *  Nastpnie przekierowuje uytkownika do serwletu, 
 *  ktry wywietla informacje o sesjach, kontekcie serwletw i cookies.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class SetSharedInfo extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    HttpSession session = request.getSession(true);
    session.setAttribute("sessionTest", "Sesja - wpis pierwszy");
    ServletContext context = getServletContext();
    context.setAttribute("servletContextTest",
                         "Kontekst serwletu - wpis pierwszy");
    Cookie c1 = new Cookie("cookieTest1", "Cookie numer jeden");
    c1.setMaxAge(3600);     // jedna godzina
    response.addCookie(c1); // cieka domylna
    Cookie c2 = new Cookie("cookieTest2", "Cookie numer dwa");
    c2.setMaxAge(3600);     // jedna godzina
    c2.setPath("/");        // cieka jawna: wszystkie adresy URL
    response.addCookie(c2);
    String url = request.getContextPath() +
                 "/showSharedInfo";
    // na wypadek, gdyby ledzenie sesji bazowao na przepisywaniu uRL
    url = response.encodeRedirectURL(url);
    response.sendRedirect(url);
  }
}
